//
//  GFMController.m
//  GameFontMaker
//
//  Created by Colin Walsh <colin@celsiusgs.com> on 10-07-06.
//  Copyright 2010 Celsius Game Studios.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with this program; if not, write to the Free Software Foundation, Inc.,
//  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#import "GFMController.h"
#include <stdio.h>
#import "bitmapcontext.h"

@implementation GFMController
@synthesize fontView;
- (IBAction)idealClick:(id)sender {
	idealPowerOfTwo = [sender state];
}
- (IBAction)drawClick:(id)sender{
	
	//Open File Dialog
	NSSavePanel *saveDlg = [NSSavePanel savePanel];
	NSArray *extensions = [NSArray arrayWithObjects:@"png",@"cft",nil];
	[saveDlg setAllowedFileTypes:extensions];
	[saveDlg setExtensionHidden:NO];
	char *fileName = NULL;
	if([saveDlg runModalForDirectory:nil file:nil] == NSOKButton)
	{
		const char *fileNameTemp = [[saveDlg filename] UTF8String];
		printf("Selected: %s\n",fileNameTemp);
		fileName = (char *)realloc(fileName, strlen(fileNameTemp)+1);
		strcpy(fileName, fileNameTemp);
	}else{
		return;
	}
	//Choose type
	[fontView setDoPreview:false];
	if(strstr(fileName, ".cft") != NULL)//Export Celsius Font file v2.0
	{
		[self exportCFT:fileName];
	}else{
		[self exportPNG:fileName];
	}
	if(fileName != NULL)free(fileName);
	[fontView setDoPreview:true];
	[fontView display];
}
//Creates a Celsius FonT v2.0 file, you probably don't care much about this bit
-(void)exportCFT:(char *)fileName {
	FILE *cftfile = fopen(fileName, "wb");
	char *header = "CFTV2.0";
	fwrite(header,1,strlen(header)+1, cftfile);
	int numglyphs = 127-32;
	fwrite(&numglyphs,sizeof(int),1,cftfile);
	int cHeight;
	int cWidth;
	unsigned char *pixeldata;
	unsigned char *finaldata;
	int avg = 0;
	for(int c=32;c<127;c++)
	{
		printf("Exporting %c\n",(char)c);
		[fontView doDrawChar:(char)c];
		[fontView display];
		pixeldata = (unsigned char *)[fontView getBitmapData];
		cWidth = [fontView getCharWidth];
		cHeight = [fontView getCharHeight];
		finaldata = (unsigned char *)malloc(cWidth*cHeight*4);
		for(int y=0;y<cHeight;y++)
		{
			for(int x=0;x<cWidth;x++)
			{
				avg = 255-(((int)pixeldata[(y*cWidth+x)*4]+(int)pixeldata[(y*cWidth+x)*4+1]+(int)pixeldata[(y*cWidth+x)*4+2])/3);
				pixeldata[(y*cWidth+x)*4]=255;
				pixeldata[(y*cWidth+x)*4+1]=255;
				pixeldata[(y*cWidth+x)*4+2]=255;
				pixeldata[(y*cWidth+x)*4+3]=(unsigned char)avg;
				
				finaldata[(((cHeight-1)-y)*cWidth+x)*4]=255;
				finaldata[(((cHeight-1)-y)*cWidth+x)*4+1]=255;
				finaldata[(((cHeight-1)-y)*cWidth+x)*4+2]=255;
				finaldata[(((cHeight-1)-y)*cWidth+x)*4+3]=(unsigned char)avg;
				
			}
		}
		fwrite(&c, sizeof(int), 1, cftfile);
		fwrite(&cWidth, sizeof(int), 1, cftfile);
		fwrite(&cHeight, sizeof(int), 1, cftfile);
		fwrite(finaldata, 1, cWidth*cHeight*4, cftfile);
		free(pixeldata);
		free(finaldata);
	}
	fclose(cftfile);
}
//Returns the height required to pack the current font into the specified width
-(int)getPackedHeight:(int)width {//brute force, could be more elegant
	int charHeight = [fontView getFontHeight];
	int curLineWidth = 0;
	int height = charHeight;
	for(int c=32;c<127;c++)
	{
		if(curLineWidth + ([fontView getCharWidth:c]+2) > width)
		{
			if(curLineWidth == 0)return -1;
			curLineWidth = 0;
			height += charHeight + 2;
			c--;
			continue;
		}else{
			curLineWidth += [fontView getCharWidth:c] + 2;
		}
	}
	return height;
}
//Exports a PNG file containing the current font
//Font will be white on a transparent alpha background
//Also creates an XML file that has width, height and offset info for the font
-(void)exportPNG:(char *)fileName {
	//Compute total ping width
	int pngWidth = 0;
	int pngHeight = [fontView getFontHeight];
	char *xmlFileName = (char *)malloc(strlen(fileName)+5);
	strcpy(xmlFileName, fileName);
	strcat(xmlFileName, ".xml");
	for(int c=32;c<127;c++)
	{
		pngWidth += [fontView getCharWidth:c] + 2;
	}
	//Messy code to try and pack the font into a power of two
	//texture with as little empty space left as possible
	if(idealPowerOfTwo)
	{
		int ideal_n = 10;
		int lastWasted = 1024*1024;
		int wasted;
		int tempWidth;
		int tempHeight;
		int nextPowerOfTwoHeight;
		int idealPowerOfTwoHeight = 0;
		for(int n=4;n<=10;n++)
		{
			tempWidth = pow(2,n);
			tempHeight = [self getPackedHeight:pow(2,n)];
			if(tempHeight < 0)continue;
			if(tempHeight > 1024)continue;
			for(int nc=0;nc<=10;nc++)
			{
				nextPowerOfTwoHeight = pow(2,nc);
				if(nextPowerOfTwoHeight >= tempHeight)break;
			}
			if(nextPowerOfTwoHeight < tempHeight)continue;
			wasted = (nextPowerOfTwoHeight - tempHeight) * tempWidth;
			
			if(wasted < lastWasted)
			{
				ideal_n = n;
				lastWasted = wasted;
				idealPowerOfTwoHeight = nextPowerOfTwoHeight;
			}
		}
		pngWidth = pow(2,ideal_n);
		pngHeight = idealPowerOfTwoHeight;
	}
				   
	printf("Total PNG width = %i\n",pngWidth);
	printf("Total PNG height = %i\n",pngHeight);
	
	CGContextRef pngRef = createBitmapContext(pngWidth, pngHeight);
	CGContextSetRGBFillColor (pngRef, 0, 0, 0, 0);
	CGContextFillRect(pngRef, CGRectMake(0, 0, pngWidth, pngHeight));

	//Zero out the PNG's buffer or else there will be garbage in the file
	unsigned char *pngData = CGBitmapContextGetData(pngRef);
	for(int x=0;x<pngWidth;x++)
	{
		for(int y=0;y<pngHeight;y++)
		{
			pngData[(y*pngWidth+x)*4]=0;
			pngData[(y*pngWidth+x)*4+1]=0;
			pngData[(y*pngWidth+x)*4+2]=0;
			pngData[(y*pngWidth+x)*4+3]=0;
		}
	}
	
	int xOffset = 0;
	int yOffset = 0;
	
	int cWidth;
	int cHeight;
	
	FILE *xmlfile = fopen(xmlFileName, "w");
	fprintf(xmlfile, "<?xml version=\"1.0\"?>\n");
	fprintf(xmlfile, "<fontdata>\n");
	unsigned char *pixeldata;
	int avg;
	for(int c=32;c<127;c++)
	{
		printf("Exporting %c\n",(char)c);
		[fontView doDrawChar:(char)c];
		[fontView display];
		cWidth = [fontView getCharWidth];
		cHeight = [fontView getCharHeight];
		pixeldata = [fontView getBitmapData];
		
		if(idealPowerOfTwo)
		{
			if(xOffset + ([fontView getCharWidth]+2) > pngWidth)
			{
				xOffset = 0;
				yOffset += ([fontView getFontHeight] + 2);
			}
		}
		for(int y=0;y<cHeight;y++)
		{
			for(int x=0;x<cWidth;x++)
			{
				avg = 255-(((int)pixeldata[(y*cWidth+x)*4]+(int)pixeldata[(y*cWidth+x)*4+1]+(int)pixeldata[(y*cWidth+x)*4+2])/3);
				pixeldata[(y*cWidth+x)*4]=255;
				pixeldata[(y*cWidth+x)*4+1]=255;
				pixeldata[(y*cWidth+x)*4+2]=255;
				pixeldata[(y*cWidth+x)*4+3]=(unsigned char)avg;		
			}
		}
		
		CGContextDrawImage(pngRef, CGRectMake(xOffset, yOffset, cWidth, cHeight), CGBitmapContextCreateImage([fontView getBitmapRef]));

		fprintf(xmlfile, "\t<glyph>\n");
		fprintf(xmlfile, "\t\t<character>%c</character>\n",c);
		fprintf(xmlfile, "\t\t<width>%i</width>\n",cWidth);
		fprintf(xmlfile, "\t\t<height>%i</height>\n",cHeight);
		fprintf(xmlfile, "\t\t<xoffset>%i</xoffset>\n",xOffset);
		fprintf(xmlfile, "\t\t<yoffset>%i</yoffset>\n",yOffset);
		fprintf(xmlfile, "\t</glyph>\n");
		
		xOffset += ([fontView getCharWidth]+2);
	}
	fprintf(xmlfile, "</fontdata>\n");
	fclose(xmlfile);
	free(xmlFileName);
	NSBitmapImageRep *bits = [[NSBitmapImageRep alloc] initWithCGImage:CGBitmapContextCreateImage(pngRef)];
	
	NSData *data = [bits representationUsingType: NSPNGFileType properties:nil];
	NSString *pngFileName = [[NSString alloc] initWithUTF8String:fileName];
	[data writeToFile:pngFileName atomically: NO];
}
@end
