//
//  GFMView.h
//
//  Created by Colin Walsh <colin@celsiusgs.com> on 10-07-06.
//  Copyright 2010 Celsius Game Studios.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with this program; if not, write to the Free Software Foundation, Inc.,
//  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


#import <Cocoa/Cocoa.h>

@interface GFMView : NSView {
	char drawChar;
	unsigned char *bitmapData;
	CGContextRef bitmapRef;
	int charWidth;
	int charHeight;
	float ascender;
	float descender;
	NSFont *drawFont;
	bool doPreview;
}
-(void)setDrawFont:(NSFont *)font;
-(void)doDrawChar:(char)c;
-(unsigned char *)getBitmapData;
-(CGContextRef)getBitmapRef;
-(int)getCharHeight;
-(int)getFontHeight;
-(int)getCharWidth;
-(int)getCharWidth:(char)c;
-(float)getAscender;
-(float)getDescender;
-(void)setDoPreview:(bool)prev;
@end
