//
//  GameFontMakerAppDelegate.m
//  GameFontMaker
//
//  Created by Colin Walsh <colin@celsiusgs.com> on 10-07-06.
//  Copyright 2010 Celsius Game Studios.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with this program; if not, write to the Free Software Foundation, Inc.,
//  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


#import "GameFontMakerAppDelegate.h"
#import "NSAttributedString.h"

@implementation GameFontMakerAppDelegate

@synthesize window;
@synthesize fontLabel;
@synthesize fontView;
@synthesize aboutTextField;

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
	// Insert code here to initialize your application 
	NSFontManager *fontManager = [NSFontManager sharedFontManager];
	gameFont = [fontManager fontWithFamily:@"Helvetica"
											  traits:NSUnboldFontMask
											  weight:0
												size:26];
	[fontManager setSelectedFont:gameFont isMultiple:false];
	[fontView setDrawFont:gameFont];
	[fontLabel setStringValue:[gameFont fontName]];
	
	[aboutTextField setAllowsEditingTextAttributes:YES];
	[aboutTextField setSelectable:YES];
	
	NSURL *url = [NSURL URLWithString:@"http://celsiusgs.com"];
	
	NSMutableAttributedString *string = [[NSMutableAttributedString alloc] init];
	[string appendAttributedString: [aboutTextField attributedStringValue]];
	[string appendAttributedString: [NSAttributedString hyperlinkFromString:@"Celsius Game Studios" withURL:url]];
	
	url = [NSURL URLWithString:@"http://www.gnu.org/licenses/gpl-2.0.txt"];
	[string appendAttributedString: [[NSAttributedString alloc] initWithString:@"\n\nGamefontMaker comes with ABSOLUTELY NO WARRANTY; This is free software, and you are welcome to redistribute it under certain conditions; "]];
	[string appendAttributedString: [NSAttributedString hyperlinkFromString:@"Click here for details" withURL:url]];
	
	[aboutTextField setAttributedStringValue: string];
}
- (void)changeFont:(id)sender
{
	NSFont *oldFont = [NSFont fontWithName:@"Helvetica" size:26];
    NSFont *newFont = [sender convertFont:oldFont];
	
	gameFont = newFont;
	[fontLabel setStringValue:[gameFont fontName]];
	[fontView setDrawFont:gameFont];
	[fontView display];
	return;
}
-(BOOL) applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)sender {
	return YES;
}
@end
