//
//  bitmapcontext.c
//  GameFontMaker
//
//  Created by Colin Walsh <colin@celsiusgs.com> on 10-07-06.
//  Copyright 2010 Celsius Game Studios.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with this program; if not, write to the Free Software Foundation, Inc.,
//  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


#include "bitmapcontext.h"

CGContextRef createBitmapContext(int pixelsWide, int pixelsHigh)
{
	
    CGContextRef context = NULL;
    CGColorSpaceRef colorSpace;
	
    int bitmapByteCount;
    int bitmapBytesPerRow;
	
    bitmapBytesPerRow = (pixelsWide * 4);
    bitmapByteCount = (bitmapBytesPerRow * pixelsHigh);
	
    colorSpace = CGColorSpaceCreateWithName(kCGColorSpaceGenericRGB);
    void *bitmapData = malloc(bitmapByteCount);
    if (bitmapData == NULL)	
    {
        fprintf(stderr, "Memory not allocated!");
        return NULL;	
    }
    context = CGBitmapContextCreate(bitmapData, pixelsWide, pixelsHigh, 8, bitmapBytesPerRow, colorSpace, kCGImageAlphaPremultipliedLast);
    if (context==NULL)
    {
        free(bitmapData);
        fprintf(stderr, "Context not created!");
        return NULL;
	}
	
	CGColorSpaceRelease(colorSpace);
	return context;
}